<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v1_1/wzbo.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v7_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v7_0/Trader.xsd" xmlns:wzbo="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v1_1/wzbo.xsd" version="1.0"> <xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/> <xsl:output encoding="iso-8859-1" method="html"/> <xsl:template match="/"> <xsl:apply-templates select="*"/> </xsl:template> <!-- POCZATEK ALL --> <!-- STYL ARKUSZA --> <xsl:template match="*" mode="styl1"> <style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style> <style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style> <style type="text/css">a{color:#3366FF;font-weight:bold;}</style> <style type="text/css">h3{padding:3px;cursor:help;}</style> <style type="text/css">h4,h5,.copyr{text-align:center;}</style> <style type="text/css">caption{font-weight:bold;}</style> <style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style> <style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style> <style type="text/css">#cont{display:none}</style> <style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style> <style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style> <style type="text/css">.nag2{font-size: 20px}</style> <style type="text/css">.cz10 {font-size: 10px}</style> <style type="text/css">.cz12 {	font-size: 12px}</style> <style type="text/css">.cz18 {font-size: 18px}</style> <style type="text/css">.cz16 {font-size: 16px}</style> <style type="text/css">.cz14 {font-size: 14px}</style> </xsl:template> <!-- SZABLON STOPKI --> <xsl:template match="*" mode="stopka"> <xsl:text>WZBO</xsl:text> </xsl:template> <xsl:template match="*"> <!-- ZASTOSOWANIE STYLU --> <xsl:apply-templates mode="styl1" select="*"/> <!-- DEKLARACJE AKCYZOWE --> <xsl:apply-templates mode="dekl_AKCS" select="."/> </xsl:template> <!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --> <xsl:template match="*" mode="dekl_AKCS"> <xsl:for-each select=" ns1:Header|  ns1:* | wzbo:*"> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:apply-templates mode="Ident" select="."/> <!-- SZABLON DLA RODZAJU DEKLARACJI --> <xsl:apply-templates mode="rodz_dekl" select="."/> <!-- SZABLON DOT.  OKRESU ROK MIESIAC  NUMER FORMULARZA--> <!--<xsl:apply-templates select="." mode = "rok_mc"/>--> <!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --> <!--<xsl:apply-templates mode="PodstawaPrawna" select="."/>--> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:apply-templates mode="MiejsceDekl" select="."/> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:apply-templates mode="DanePodatnika" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:apply-templates mode="Adres" select="."/> <!-- SZABLON DOT. ADRESU PODATNIKA --> <!-- SZABLON DOT. POZOSTALI PODATNICY--> <!--<xsl:apply-templates mode="Pozostali" select="."/> --> <!-- SZABLON DOT. ADRESU WSPÓŁWŁAŚCICELA --> <!-- <xsl:apply-templates mode="AdresW" select="."/> --> <!-- xsl:apply-templates mode="KwotaPodatku" select="."/> --> <!-- SZABLON DOT. WYROBOW --> <!-- <xsl:apply-templates mode="Wyroby" select="."/> --> <!-- SZABLON DOT. WYROBOW --> <!-- <xsl:apply-templates mode="Wyroby1" select="."/> --> <xsl:apply-templates mode="Wyroby3" select="."/> <!-- <xsl:apply-templates mode="Razem" select="."/> --> <!-- SZABLON DOT. OSWIADCZENIE karnej --> <xsl:apply-templates mode="Zalaczniki" select="."/> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:apply-templates mode="OswPodatnika" select="."/> <!-- SZABLON DOT. ADNOTACJI--> <!-- <xsl:apply-templates mode="Adnotacje" select="."/>--> <!-- SZABLON DOT. OBJASNIENIA --> <!--<xsl:apply-templates mode="ObjasnieniaAkc" select="."/> --> <!-- SZABLON DOT. POUCZENIA--> <!-- <xsl:apply-templates mode="PouczeniaAkc" select="."/>--> </xsl:for-each> </xsl:template> <!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--> <xsl:template match="*" mode="Ident"> <table border="1" width="955"> <tr align="left" valign="top"> <td align="left" colspan="2" height="45" valign="middle" width="586"> <span class="cz12"> <xsl:choose> <xsl:when test="string-length(@identifier)='11'"> <b>1. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> podatnika</b>  </xsl:when> <xsl:otherwise> <b>1. Identyfikator podatkowy NIP/<s>numer PESEL</s> <sup>(niepotrzebne skreślić)</sup> podatnika </b> </xsl:otherwise> </xsl:choose> </span> </td> <td align="center" colspan="2" valign="middle" width="353"> <span class="nag2"> <b> <xsl:value-of select="@identifier"/> </b> </span> </td> </tr> <tr align="left" colspan="1" valign="top"> <td align="left" height="45" valign="top" width="353"/> <td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"> <b>2. Nr dokumentu</b> <br/> <span class="cz16"> <b> <xsl:value-of select="@selfRef"/> </b> </span> </td> <td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"> <b>3. Status</b> </td> </tr> </table> </xsl:template> <!-- SZABLON DOT.  RODZAJU DEKLARACJI --> <xsl:template match="*" mode="rodz_dekl"> <xsl:if test="ns1:* | wzbo:*"> <table border="1" width="956"> <!--<tr> <td colspan="3" height="40"> <span class="nag1"> <xsl:text>WZBO</xsl:text> </span> </td> </tr> --> <tr> <td align="center" bgcolor="#CCCCCC" height="61" width="120"> <span class="nag1"> WZBO </span> </td> <td align="center" width="537"> <div> <span class="nag1"> <br/>WNIOSEK O WYDANIE DOKUMENTU POTWIERDZAJĄCEGO<br/> BRAK OBOWIĄZKU ZAPŁATY AKCYZY NA TERYTORIUM KRAJU<br/> </span> <span class="nag1"/> </div> </td> <!--<td width="243"/>--> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --> <xsl:template match="*" mode="MiejsceDekl"> <xsl:if test="ns1:* |wzbo:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <span class="nag1">A.WŁAŚCIWY ORGAN I CEL SKŁADANIA WNIOSKU</span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="5" width="46"/> <td colspan="2"> <b>4. Naczelnik urzędu skarbowego</b> <br/> <span class="cz18"> <xsl:value-of select="@taxOfficeName"/> </span> </td> </tr> <!--<tr> <td class="style3" colspan="2"> <b>6. Cel złożenia formularza</b>(zaznaczyć właściwy kwadrat):  </td> </tr> --> <!-- <tr> <td align="left" valign="top" width="422">1. złożenie deklaracji<br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Deklaracja'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> </xsl:if> </td> <td align="left" valign="top" width="471">2. korekta deklaracji<sup>3)</sup> <br/> <xsl:if test="@submissionAim and normalize-space(@submissionAim)='Korekta'"> <span class="cz18"> <b>X - </b> <xsl:value-of select="@submissionAim"/> </span> <br/>  </xsl:if> </td> </tr> --> <tr> <td class="style3" colspan="2"> <b>5. Podstawa prawna wskazująca na brak obowiązku zapłaty akcyzy za samochód, dotyczy wszystkich wnioskowanych VIN</b> <br/> <p> <xsl:choose> <xsl:when test=".//ns1:LegalBasis/@optionLegalBasis='samochodOsobowy'"> <span class="cz18"> ☑ </span> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> z tytułu nabycia wewnątrzwspólnotowego samochodu osobowego niezarejestrowanego wcześniej na terytorium kraju</p> <p> <xsl:choose> <xsl:when test=".//ns1:LegalBasis/@optionLegalBasis='samochodCiezarowy'"> <span class="cz18"> ☑ </span> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> z tytułu nabycia wewnątrzwspólnotowego samochodu ciężarowego lub specjalnego, o dopuszczalnej masie całkowitej nieprzekraczającej 3,5 t</p> <p> <xsl:choose> <xsl:when test=".//ns1:LegalBasis/@optionLegalBasis='zmianyKonstrukcyjne'"> <span class="cz18"> ☑ </span> </xsl:when> <xsl:otherwise> <b/> <b/> </xsl:otherwise> </xsl:choose> z tytułu dokonania w pojeździe zarejestrowanym na terytorium kraju zmian konstrukcyjnych zmieniających rodzaj tego pojazdu na samochód ciężarowy<br/>    lub specjalny, o dopuszczalnej masie całkowitej nieprzekraczającej 3,5 t</p> <BR/> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. DANYCH PODATNIKA --> <xsl:template match="*" mode="DanePodatnika"> <xsl:if test="ns4:* | wzbo:*"> <table border="1" width="955"> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag1">B. DANE PODATNIKA</span> </td> </tr> <tr bgcolor="#CCCCCC"> <td colspan="4"> <span class="nag2">B.1. DANE IDENTYFIKACYJNE</span> </td> </tr> <tr> <td bgcolor="#CCCCCC" rowspan="3" width="40"/> <td align="left" colspan="3" height="27" valign="top"> <b>6. Rodzaj podatnika</b>(zaznaczyć właściwy kwadrat): </td> </tr> <tr> <xsl:if test=".//@typeOfTaxpayer='N'"> <td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/> <span class="cz18"> ☑ </span> </td> <td align="left" valign="top" width="471">2. osoba fizyczna<br/> <span class="cz18"> ☐ </span> </td> </xsl:if> <xsl:if test=".//@typeOfTaxpayer='F'"> <td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/> <span class="cz18"> ☐ </span> </td> <td align="left" valign="top" width="471">2. osoba fizyczna<br/> <span class="cz18"> ☑ </span> <br/> </td> </xsl:if> </tr> <tr> <td align="left" colspan="3" valign="top"> <b>7. Nazwa pełna /Nazwisko, pierwsze imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@fullName"/> </span> <span class="cz18"> <xsl:value-of select=".//ns4:PrivatePerson/ns4:BasicData/@surname"/> </span> <span class="cz18"> <xsl:value-of select=".//ns4:PrivatePerson/ns4:BasicData/@firstName"/> </span> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ADRESU PODATNIKA --> <xsl:template match="*" mode="Adres"> <xsl:if test="ns1:* | wzbo:*"> <!-- Tabelka od nowa --> <table border="1" width="955"> <tr bgcolor="#cccccc"> <td colspan="6"> <span class="nag2">B.2. ADRES SIEDZIBY / ADRES ZAMIESZKANIA </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#cccccc" rowspan="3" style="width: 41px;"> </td> <td style="width: 104px;"> <b>8. Kraj </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@country"/> </span> </td> <td colspan="2" style="width: 337px;"> <b>9. Województwo</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@provinceName"/> </span> </td> <td colspan="2" style="width: 419px;"> <b>10. Powiat</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@districtName"/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="3" style="width: 447px;"> <b>11. Gmina </b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@communeName"/> </span> </td> <td colspan="2" style="width: 419px;"> <b>12. Ulica</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@street"/> </span> </td> </tr> <tr align="left" valign="top"> <td style="width: 104px;"> <b>13. Nr domu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@houseNumber"/> </span> </td> <td style="width: 117px;"> <b>14. Nr lokalu</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@localNumber"/> </span> </td> <td colspan="2" style="width: 418px;"> <b>15. Miejscowość</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@city"/> </span> </td> <td style="width: 164px;"> <b>16. Kod pocztowy</b> <br/> <br/> <span class="cz18"> <xsl:value-of select=".//@postalCode"/> </span> </td> </tr> </table> <!--	<table width="955"> <tr align="right" valign="top"> <td > <span class="nag1"> AKC-US </span> <sub style="cz9">(1)</sub> </td> </tr> </table> --> </xsl:if> </xsl:template> <!-- SZABLON WYROBÓW wzbo --> <xsl:template match="ns1:* | wzbo:*" mode="Wyroby3"> <xsl:if test="ns1:* | wzbo:*"> <table border="1" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td bgcolor="#CCCCCC" class="nag1" colspan="9"> C. DANE POJAZDU</td> </tr> <xsl:for-each select=".//ns1:Item"> <tr border-style="solid" style="height: 18px;"> <td rowspan="2" style="width: 9.4898%; height: 18px;"> <span class="cz14"> <xsl:value-of select="@id"/> </span> </td> <td style="width: 25.6122%; height: 18px;"> <b>Marka:</b> <br/> <br/> <div align="right" class="cz14"> <i> <xsl:value-of select="@mark"/> </i> </div> </td> <td style="width: 31.7347%; height: 18px;"> <b>Model:</b> <br/> <br/> <div align="right" class="cz14"> <i> <xsl:value-of select="@model"/> </i> </div> </td> <td style="width: 33.1633%; height: 18px;"> <b>Numer VIN / nadwozia / podwozia / ramy:</b> <br/> <br/> <xsl:if test="@customVIN='false'"> <i> <sup>niestandardowy VIN</sup> </i> <br/> </xsl:if> <div align="right" class="cz14"> <i> <xsl:value-of select="@VIN"/> </i> </div> </td> </tr> <tr style="height: 18px;"> <td style="width: 25.6122%; height: 18px;"> <b>Rok produkcji:</b> <br/> <br/> <div align="right" class="cz14"> <i> <xsl:value-of select="@yearOfProduction"/> </i> </div> </td> <td style="width: 31.7347%; height: 18px;"> <b>Moc silnika w kW</b> <br/> <div align="right" class="cz14"> <i> <xsl:value-of select="@enginePower"/> </i> </div> </td> <td style="width: 33.1633%; height: 18px;"> <b>Pojemność silnika w cm<sup>3</sup> </b> <br/> <div align="right" class="cz14"> <i> <xsl:value-of select="@capacityOfEngine"/> </i> </div> </td> </tr> </xsl:for-each> </table> </xsl:if> </xsl:template> <xsl:template match="*" mode="Razem"> <xsl:if test="ns1:* | wzbo:*"> <table border="1" width="955"> <tr> <td bgcolor="#cccccc" colspan="4" style="width: 262.25px;" valign="top"> <b>Razem podatek akcyzowy</b> (suma wszystkich pól 52) :</td> <td colspan="2" style="width: 367.75px;"> <b>53.</b> <br/> <div align="right" class="cz18" valign="top"> <xsl:value-of select="format-number(number(.//@sum),'# ##0')"/> zł </div> </td> </tr> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. ZAŁACZNIKÓW --> <xsl:template match="*" mode="Zalaczniki"> <xsl:if test="ns1:* | wzbo:*"> <table border="1" width="955"> <tbody> <tr bgcolor="#cccccc"> <td colspan="6"> <span class="nag1">D. LISTA ZAŁĄCZNIKÓW </span> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#cccccc" style="width: 41px;"> </td> <td colspan="3" style="width: 716px;"> <b>17. Numer w CRKID nadany dla pliku załącznika</b> <br/> <xsl:for-each select=".//ns1:ItemAttachments"> <br/> <span class="cz18"> <xsl:value-of select="@attachmentNumber"/> </span> </xsl:for-each> </td> </tr> </tbody> </table> </xsl:if> </xsl:template> <!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --> <xsl:template match="*" mode="OswPodatnika"> <xsl:if test="ns1:* | ns3:*"> <table border="1" height="210" width="955"> <tr align="left" bgcolor="#CCCCCC" valign="top"> <td colspan="3"> <b> <span class="nag1">E. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span> </b> <!--<br/>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.--> </td> </tr> <tr align="left" valign="top"> <td bgcolor="#CCCCCC" rowspan="4" width="40"/> <td height="37" width="402"> <b>18. Imię </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repFirstName"/> </span> </td> <td width="491"> <b>19. Nazwisko </b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repSurname "/> </span> </td> </tr> <tr align="left" valign="top"> <td colspan="2"> <xsl:choose> <xsl:when test="string-length(//@repIdentifier)='11'"> <b>20. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b> <sup>(niepotrzebne skreślić)</sup> <b> osoby reprezentującej podatnika</b> </xsl:when> <xsl:otherwise> <b>20. Identyfikator podatkowy NIP/<s>numer PESEL</s> </b> <sup>(niepotrzebne skreślić)</sup> <b> osoby reprezentującej podatnika</b> </xsl:otherwise> </xsl:choose> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@repIdentifier"/> </span> </td> </tr> <tr align="left" valign="top"> <td height="39"> <b>21. Data wypełnienia wniosku</b> (dzień – miesiąc – rok) <br/> <br/> <br/> <span class="cz18"> <xsl:value-of select="substring(//@declarationDate,9,2)"/> <xsl:value-of select="substring(//@declarationDate,5,4)"/> <xsl:value-of select="substring(//@declarationDate,1,4)"/> </span> </td> <td> <b>22. Podpis podatnika lub osoby reprezentującej podatnika </b> </td> </tr> <tr align="left" valign="top"> <td colspan="3"> <b>23. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika</b> <br/> <br/> <span class="cz18"> <xsl:value-of select="//@phone"/> </span> <span class="cz18"> <xsl:value-of select="//@email"/> </span> </td> </tr> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"> WZBO <sub>(2)</sub> </span> <sub style="cz9"/> </td> </tr> </table> </xsl:if> </xsl:template>  <!-- KONIEC all AG--> </xsl:stylesheet>